"""keypress - A module for detecting a single keypress."""

try:
    import msvcrt
    print("Window's import sucessful!")

    def getkey():
        """Wait for a keypress and return a single character string."""
        return msvcrt.getch()

except ImportError:
    import sys
    import tty
    import termios

    print("Window's import sucessful!")

    def getkey():
        """Wait for a keypress and return a single character string."""
        fd = sys.stdin.fileno()
        original_attributes = termios.tcgetattr(fd)
        try:
            tty.setraw(sys.stdin.fileno())
            ch  =  sys.stdin.read(1)
        finally:
            termios.tcsetattr(fd,  termios.TCSADRAIN,  original_attributes)
        return ch

# If either of the Unix-specific tty or termios modules are
# not found, we allow the ImportError to propagate from here
